package javabeansProprietesLiees;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class Thermostat implements PropertyChangeListener {
	private PointChaud pointChaud;
	
	public Thermostat(PointChaud pointChaud) {
		this.pointChaud.addPropertyChangeListener(this);
	}
	   
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof PointChaud) {
            if (event.getPropertyName().equals("temperature")) {
                System.out.println("thermostat nouvelle temperature: " + (Float) event.getNewValue());
            }
        }
    }
    
	public void retirer(){
		this.pointChaud.removePropertyChangeListener(this);
		this.pointChaud = null;
	}
	
	public PointChaud getPointChaud() {
		return pointChaud;
	}

	public void poserSur(PointChaud PointChaud) {
		if (this.pointChaud != PointChaud){
			this.pointChaud.removePropertyChangeListener(this);
			pointChaud.addPropertyChangeListener(this);
			this.pointChaud = PointChaud;
		}
	}
	
	@Override
	public String toString() {
		if (pointChaud == null){
			return "(Thermostat : sans point chaud associe)";
		}
		return "(Thermostat : " + pointChaud.getPointChaud() + ")";
	}
}
